/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.console.RemoveAction;
import org.sonarlint.eclipse.ui.internal.console.SonarLintConsole;

public class SonarLintConsolePageParticipant
implements IConsolePageParticipant {
    private DebugAction debugAction;
    private ShowConsoleAction showOnOutputAction;
    private IAction consoleRemoveAction;

    public void init(IPageBookViewPage page, IConsole console) {
        this.consoleRemoveAction = new RemoveAction();
        this.debugAction = new DebugAction();
        this.showOnOutputAction = new ShowConsoleAction();
        IActionBars actionBars = page.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
    }

    private void configureToolBar(IToolBarManager manager) {
        manager.prependToGroup("launchGroup", this.consoleRemoveAction);
        manager.prependToGroup("outputGroup", (IAction)this.debugAction);
        manager.appendToGroup("outputGroup", (IAction)this.showOnOutputAction);
    }

    public void dispose() {
        this.debugAction.dispose();
        this.debugAction = null;
        this.showOnOutputAction.dispose();
        this.showOnOutputAction = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    static class DebugAction
    extends Action {
        private final IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("debugOutput".equals(event.getProperty())) {
                    DebugAction.this.setChecked(SonarLintConsole.isDebugEnabled());
                }
            }
        };

        public DebugAction() {
            this.setToolTipText(Messages.SonarDebugOutputAction_tooltip);
            this.setImageDescriptor(SonarLintImages.DEBUG);
            DebugAction.getPreferenceStore().addPropertyChangeListener(this.listener);
            this.setChecked(SonarLintConsole.isDebugEnabled());
        }

        public void dispose() {
            DebugAction.getPreferenceStore().removePropertyChangeListener(this.listener);
        }

        public void run() {
            DebugAction.getPreferenceStore().setValue("debugOutput", this.isChecked());
        }

        private static IPreferenceStore getPreferenceStore() {
            return SonarLintUiPlugin.getDefault().getPreferenceStore();
        }
    }

    static class ShowConsoleAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public ShowConsoleAction() {
            this.setToolTipText(Messages.SonarShowConsoleAction_tooltip);
            this.setImageDescriptor(SonarLintImages.SHOW_CONSOLE);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_never_text, "never"));
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_onOutput_text, "onOutput"));
            ShowConsoleAction.addActionToMenu(this.menu, new MyAction(Messages.SonarShowConsoleAction_onError_text, "onError"));
            return this.menu;
        }

        private static void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private static IPreferenceStore getPreferenceStore() {
            return SonarLintUiPlugin.getDefault().getPreferenceStore();
        }

        private static String getCurrentValue() {
            return ShowConsoleAction.getPreferenceStore().getString("showConsole");
        }

        static class MyAction
        extends Action {
            private final String value;

            public MyAction(String name, String value) {
                super(name, 8);
                this.value = value;
                this.setChecked(value.equals(ShowConsoleAction.getCurrentValue()));
            }

            public void run() {
                ShowConsoleAction.getPreferenceStore().setValue("showConsole", this.value);
            }
        }
    }
}

